/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.global;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.api.constants.OptionType;
import noppes.npcs.client.Client;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.SubGuiEditText;
import noppes.npcs.client.gui.global.GuiDialogEdit;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcCheckBox;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogCategory;
import noppes.npcs.controllers.data.DialogOption;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.Util;

public class GuiNPCManageDialogs
extends GuiNPCInterface2
implements ISubGuiListener,
ICustomScrollListener,
GuiYesNoCallback {
    public static GuiScreen Instance;
    private final Map<String, DialogCategory> categoryData = new TreeMap<String, DialogCategory>();
    private final Map<String, Dialog> dialogData = new LinkedHashMap<String, Dialog>();
    private GuiCustomScroll scrollCategories;
    private GuiCustomScroll scrollDialogs;
    protected static boolean isName;
    protected String selectedCategory = "";
    protected String selectedDialog = "";
    protected Dialog copyDialog = null;

    public GuiNPCManageDialogs(EntityNPCInterface npc) {
        super(npc);
        Instance = this;
        Client.sendData(EnumPacketServer.DialogCategoryGet, new Object[0]);
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 1: {
                this.setSubGui(new SubGuiEditText(1, Util.instance.deleteColor(new TextComponentTranslation("gui.new", new Object[0]).func_150254_d())));
                break;
            }
            case 2: {
                if (!this.categoryData.containsKey(this.selectedCategory)) {
                    return;
                }
                GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, this.categoryData.get((Object)this.selectedCategory).title, new TextComponentTranslation("gui.deleteMessage", new Object[0]).func_150254_d(), 2);
                this.displayGuiScreen((GuiScreen)guiyesno);
                break;
            }
            case 3: {
                if (!this.dialogData.containsKey(this.selectedDialog)) {
                    return;
                }
                this.setSubGui(new SubGuiEditText(3, this.categoryData.get((Object)this.selectedCategory).title));
                break;
            }
            case 9: {
                if (this.copyDialog == null || !this.categoryData.containsKey(this.selectedCategory)) {
                    return;
                }
                Dialog dialog = this.copyDialog.copy(null);
                dialog.id = -1;
                dialog.category = this.categoryData.get(this.selectedCategory);
                StringBuilder t = new StringBuilder(dialog.title);
                boolean has = true;
                while (has) {
                    has = false;
                    for (Dialog dia : dialog.category.dialogs.values()) {
                        if (dia.id == dialog.id || !dia.title.equalsIgnoreCase(t.toString())) continue;
                        has = true;
                        break;
                    }
                    if (!has) continue;
                    t.append("_");
                }
                this.selectedDialog = dialog.title = t.toString();
                Client.sendData(EnumPacketServer.DialogSave, this.categoryData.get((Object)this.selectedCategory).id, dialog.save(new NBTTagCompound()));
                this.func_73866_w_();
                break;
            }
            case 10: {
                if (!this.dialogData.containsKey(this.selectedDialog)) {
                    return;
                }
                this.copyDialog = this.dialogData.get(this.selectedDialog);
                this.func_73866_w_();
                break;
            }
            case 11: {
                this.setSubGui(new SubGuiEditText(11, Util.instance.deleteColor(new TextComponentTranslation("gui.new", new Object[0]).func_150254_d())));
                break;
            }
            case 12: {
                if (!this.dialogData.containsKey(this.selectedDialog)) {
                    return;
                }
                GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, this.dialogData.get(this.selectedDialog).getKey(), new TextComponentTranslation("gui.deleteMessage", new Object[0]).func_150254_d(), 12);
                this.displayGuiScreen((GuiScreen)guiyesno);
                break;
            }
            case 13: {
                if (!this.dialogData.containsKey(this.selectedDialog)) {
                    return;
                }
                this.setSubGui(new GuiDialogEdit(this.npc, this.dialogData.get(this.selectedDialog), this));
                break;
            }
            case 14: {
                isName = ((GuiNpcCheckBox)button).isSelected();
                button.setHoverText("hover.sort", new TextComponentTranslation("dialog.dialogs", new Object[0]).func_150254_d(), ((GuiNpcCheckBox)button).getText());
            }
        }
    }

    @Override
    public void close() {
        super.close();
    }

    public void func_73878_a(boolean result, int id) {
        NoppesUtil.openGUI((EntityPlayer)this.player, this);
        if (!result) {
            return;
        }
        if (id == 2) {
            Client.sendData(EnumPacketServer.DialogCategoryRemove, this.categoryData.get((Object)this.selectedCategory).id);
            this.selectedCategory = "";
            this.selectedDialog = "";
        }
        if (id == 12) {
            Client.sendData(EnumPacketServer.DialogRemove, this.dialogData.get((Object)this.selectedDialog).id);
            this.selectedDialog = "";
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.categoryData.clear();
        this.dialogData.clear();
        DialogController dData = DialogController.instance;
        for (DialogCategory category : dData.categories.values()) {
            this.categoryData.put(category.title, category);
            if (!this.selectedCategory.isEmpty()) continue;
            this.selectedCategory = category.title;
        }
        LinkedHashMap<Integer, List<String>> hts = new LinkedHashMap<Integer, List<String>>();
        if (!this.selectedCategory.isEmpty()) {
            if (this.categoryData.containsKey(this.selectedCategory)) {
                TreeMap<String, Dialog> map = new TreeMap<String, Dialog>();
                for (Dialog dialog : this.categoryData.get((Object)this.selectedCategory).dialogs.values()) {
                    boolean b = !dialog.text.isEmpty();
                    String key = "\u00a77ID:" + dialog.id + "-\"" + '\u00a7' + "r" + new TextComponentTranslation(dialog.title, new Object[0]).func_150254_d() + '\u00a7' + "7\"" + '\u00a7' + (b ? "2 (" : "c (") + new TextComponentTranslation("quest.has." + b, new Object[0]).func_150254_d() + '\u00a7' + (b ? "2)" : "c)");
                    map.put(key, dialog);
                }
                for (Map.Entry entry : GuiNPCManageDialogs.getEntryList(map)) {
                    this.dialogData.put((String)entry.getKey(), (Dialog)entry.getValue());
                    if (!this.selectedDialog.isEmpty()) continue;
                    this.selectedDialog = (String)entry.getKey();
                }
                if (!this.dialogData.isEmpty()) {
                    int pos = 0;
                    TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
                    for (Dialog dialog : this.dialogData.values()) {
                        ArrayList<String> h = new ArrayList<String>();
                        ArrayList<String> activationDialogs = new ArrayList<String>();
                        ArrayList<String> nextDialogs = new ArrayList<String>();
                        h.add(new TextComponentTranslation(dialog.title, new Object[0]).func_150254_d() + ":");
                        for (DialogOption option : dialog.options.values()) {
                            if (option.optionType != OptionType.DIALOG_OPTION || option.dialogs.isEmpty()) continue;
                            int i = 0;
                            for (DialogOption.OptionDialogID od : option.dialogs) {
                                treeMap.put(option.slot + "." + i, od.dialogId);
                                ++i;
                            }
                        }
                        try {
                            Set<Integer> dSet = dData.dialogs.keySet();
                            for (int dialogId : dSet) {
                                if (!dData.hasDialog(dialogId)) continue;
                                Dialog d = dData.get(dialogId);
                                for (DialogOption option : d.options.values()) {
                                    if (option.optionType != OptionType.DIALOG_OPTION || option.dialogs.isEmpty()) continue;
                                    int i = 0;
                                    for (DialogOption.OptionDialogID od : option.dialogs) {
                                        if (od.dialogId != dialog.id) continue;
                                        activationDialogs.add("\u00a77ID:" + d.id + '\u00a7' + "8 " + new TextComponentTranslation("gui.answer", new Object[0]).func_150254_d() + '\u00a7' + "8: " + '\u00a7' + "7" + option.slot + "." + i + '\u00a7' + "8; " + d.category.getName() + "/" + '\u00a7' + "r" + d.getName());
                                        ++i;
                                    }
                                }
                                if (!treeMap.containsValue(d.id)) continue;
                                for (String k : treeMap.keySet()) {
                                    if ((Integer)treeMap.get(k) != d.id) continue;
                                    nextDialogs.add("\u00a78" + new TextComponentTranslation("gui.answer", new Object[0]).func_150254_d() + '\u00a7' + "8: " + '\u00a7' + "7" + k + '\u00a7' + "7 ID:" + d.id + '\u00a7' + "8; " + d.category.getName() + "/" + '\u00a7' + "r" + d.getName());
                                }
                            }
                        }
                        catch (Exception e) {
                            LogWriter.error(e);
                        }
                        if (!activationDialogs.isEmpty()) {
                            h.add(new TextComponentTranslation("dialog.hover.act.1", new Object[0]).func_150254_d());
                            h.addAll(activationDialogs);
                        } else {
                            h.add(new TextComponentTranslation("dialog.hover.act.0", new Object[0]).func_150254_d());
                        }
                        if (!nextDialogs.isEmpty()) {
                            h.add(new TextComponentTranslation("dialog.hover.next.1", new Object[0]).func_150254_d());
                            h.addAll(nextDialogs);
                        } else {
                            h.add(new TextComponentTranslation("dialog.hover.next.0", new Object[0]).func_150254_d());
                        }
                        hts.put(pos, h);
                        ++pos;
                    }
                }
            } else {
                this.selectedCategory = "";
                this.selectedDialog = "";
            }
        }
        this.addLabel(new GuiNpcLabel(0, "gui.categories", this.guiLeft + 8, this.guiTop + 4));
        this.addLabel(new GuiNpcLabel(1, "dialog.dialogs", this.guiLeft + 180, this.guiTop + 4));
        int x = this.guiLeft + 350;
        int y = this.guiTop + 8;
        this.addLabel(new GuiNpcLabel(3, "dialog.dialogs", x + 2, y));
        GuiNpcButton guiNpcButton = new GuiNpcButton(13, x, y += 10, 64, 15, "selectServer.edit", !this.selectedDialog.isEmpty());
        guiNpcButton.setHoverText("manager.hover.dialog.edit", this.selectedDialog);
        this.addButton(guiNpcButton);
        GuiNpcButton guiNpcButton2 = new GuiNpcButton(12, x, y += 17, 64, 15, "gui.remove", !this.selectedDialog.isEmpty());
        guiNpcButton2.setHoverText("manager.hover.dialog.del", this.selectedDialog);
        this.addButton(guiNpcButton2);
        GuiNpcButton guiNpcButton3 = new GuiNpcButton(11, x, y += 17, 64, 15, "gui.add", !this.selectedCategory.isEmpty());
        guiNpcButton3.setHoverText("manager.hover.dialog.add", this.selectedCategory);
        this.addButton(guiNpcButton3);
        GuiNpcButton guiNpcButton4 = new GuiNpcButton(10, x, y += 21, 64, 15, "gui.copy", !this.selectedCategory.isEmpty());
        guiNpcButton4.setHoverText("manager.hover.dialog.copy", this.selectedDialog);
        this.addButton(guiNpcButton4);
        GuiNpcButton guiNpcButton5 = new GuiNpcButton(9, x, y += 17, 64, 15, "gui.paste", this.copyDialog != null);
        guiNpcButton5.setHoverText("manager.hover.dialog.paste." + (this.copyDialog != null), this.copyDialog != null ? this.copyDialog.getKey() : "");
        this.addButton(guiNpcButton5);
        GuiNpcCheckBox guiNpcCheckBox = new GuiNpcCheckBox(14, x, y + 17, 64, 14, "gui.name", "ID", isName);
        guiNpcCheckBox.setHoverText("hover.sort", new TextComponentTranslation("dialog.dialogs", new Object[0]).func_150254_d(), guiNpcCheckBox.getText());
        this.addButton(guiNpcCheckBox);
        y = this.guiTop + 130;
        this.addLabel(new GuiNpcLabel(2, "gui.categories", x + 2, y));
        GuiNpcButton guiNpcButton6 = new GuiNpcButton(3, x, y += 10, 64, 15, "selectServer.edit", !this.selectedCategory.isEmpty());
        guiNpcButton6.setHoverText("manager.hover.category.edit", new Object[0]);
        this.addButton(guiNpcButton6);
        GuiNpcButton guiNpcButton7 = new GuiNpcButton(2, x, y += 17, 64, 15, "gui.remove", !this.selectedCategory.isEmpty());
        guiNpcButton7.setHoverText("manager.hover.category.del", new Object[0]);
        this.addButton(guiNpcButton7);
        GuiNpcButton guiNpcButton8 = new GuiNpcButton(1, x, y + 17, 64, 15, "gui.add");
        guiNpcButton8.setHoverText("manager.hover.category.add", new Object[0]);
        this.addButton(guiNpcButton8);
        if (this.scrollCategories == null) {
            this.scrollCategories = new GuiCustomScroll(this, 0);
            this.scrollCategories.setSize(170, this.ySize - 3);
        }
        this.scrollCategories.setList(new ArrayList<String>(this.categoryData.keySet()));
        this.scrollCategories.guiLeft = this.guiLeft + 4;
        this.scrollCategories.guiTop = this.guiTop + 15;
        if (!this.selectedCategory.isEmpty()) {
            this.scrollCategories.setSelected(this.selectedCategory);
        }
        this.addScroll(this.scrollCategories);
        if (this.scrollDialogs == null) {
            this.scrollDialogs = new GuiCustomScroll(this, 1);
            this.scrollDialogs.setSize(170, this.ySize - 3);
        }
        this.scrollDialogs.setListNotSorted(new ArrayList<String>(this.dialogData.keySet()));
        this.scrollDialogs.guiLeft = this.guiLeft + 176;
        this.scrollDialogs.guiTop = this.guiTop + 15;
        if (!this.selectedDialog.isEmpty()) {
            this.scrollDialogs.setSelected(this.selectedDialog);
        }
        this.scrollDialogs.setHoverTexts(hts);
        this.addScroll(this.scrollDialogs);
    }

    @Override
    public void save() {
        GuiNpcTextField.unfocus();
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        if (!scroll.hasSelected()) {
            return;
        }
        if (scroll.getID() == 0) {
            if (this.selectedCategory.equals(scroll.getSelected())) {
                return;
            }
            this.selectedCategory = scroll.getSelected();
            this.selectedDialog = "";
            scroll.setSelect(-1);
        } else if (scroll.getID() == 1) {
            if (this.selectedDialog.equals(scroll.getSelected())) {
                return;
            }
            this.selectedDialog = scroll.getSelected();
        }
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String selection, IGuiCustomScroll scroll) {
        if (!this.selectedDialog.isEmpty() && scroll.getID() == 1) {
            this.setSubGui(new GuiDialogEdit(this.npc, this.dialogData.get(this.selectedDialog), this));
        }
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
        if (subgui instanceof SubGuiEditText && !((SubGuiEditText)subgui).cancelled) {
            boolean has;
            StringBuilder t;
            DialogCategory category;
            if (subgui.getId() == 1) {
                category = new DialogCategory();
                t = new StringBuilder(((SubGuiEditText)subgui).text[0]);
                has = true;
                while (has) {
                    has = false;
                    for (DialogCategory cat : DialogController.instance.categories.values()) {
                        if (category.id == cat.id || !cat.title.equalsIgnoreCase(t.toString())) continue;
                        has = true;
                        break;
                    }
                    if (!has) continue;
                    t.append("_");
                }
                category.title = t.toString();
                Client.sendData(EnumPacketServer.DialogCategorySave, category.save(new NBTTagCompound()));
            }
            if (subgui.getId() == 3) {
                if (((SubGuiEditText)subgui).text[0].isEmpty() || !this.categoryData.containsKey(this.selectedCategory)) {
                    return;
                }
                category = this.categoryData.get(this.selectedCategory).copy();
                if (category.title.equals(((SubGuiEditText)subgui).text[0])) {
                    return;
                }
                category.title = ((SubGuiEditText)subgui).text[0];
                t = new StringBuilder(((SubGuiEditText)subgui).text[0]);
                has = true;
                while (has) {
                    has = false;
                    for (DialogCategory cat : DialogController.instance.categories.values()) {
                        if (category.id == cat.id || !cat.title.equalsIgnoreCase(t.toString())) continue;
                        has = true;
                        break;
                    }
                    if (!has) continue;
                    t.append("_");
                }
                this.selectedCategory = category.title = t.toString();
                Client.sendData(EnumPacketServer.DialogCategorySave, category.save(new NBTTagCompound()));
                this.func_73866_w_();
            }
            if (subgui.getId() == 11) {
                if (((SubGuiEditText)subgui).text[0].isEmpty()) {
                    return;
                }
                Dialog dialog = new Dialog(this.categoryData.get(this.selectedCategory));
                t = new StringBuilder(((SubGuiEditText)subgui).text[0]);
                has = true;
                while (has) {
                    has = false;
                    for (Dialog dia : dialog.category.dialogs.values()) {
                        if (dia.id == dialog.id || !dia.title.equalsIgnoreCase(t.toString())) continue;
                        has = true;
                        break;
                    }
                    if (!has) continue;
                    t.append("_");
                }
                this.selectedDialog = dialog.title = t.toString();
                Client.sendData(EnumPacketServer.DialogSave, this.categoryData.get((Object)this.selectedCategory).id, dialog.save(new NBTTagCompound()));
                this.func_73866_w_();
            }
        }
        if (subgui instanceof GuiDialogEdit) {
            this.func_73866_w_();
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.hasSubGui()) {
            return;
        }
        this.func_73730_a(this.guiLeft + 348, this.guiLeft + 414, this.guiTop + 128, Integer.MIN_VALUE);
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (i == 1 && this.subgui == null) {
            this.save();
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.MainMenuGlobal);
            return;
        }
        super.func_73869_a(c, i);
    }

    private static List<Map.Entry<String, Dialog>> getEntryList(Map<String, Dialog> map) {
        ArrayList<Map.Entry<String, Dialog>> list = new ArrayList<Map.Entry<String, Dialog>>(map.entrySet());
        list.sort((d_0, d_1) -> {
            if (isName) {
                String n_0 = Util.instance.deleteColor(new TextComponentTranslation(((Dialog)d_0.getValue()).title, new Object[0]).func_150254_d() + "_" + ((Dialog)d_0.getValue()).id).toLowerCase();
                String n_1 = Util.instance.deleteColor(new TextComponentTranslation(((Dialog)d_1.getValue()).title, new Object[0]).func_150254_d() + "_" + ((Dialog)d_1.getValue()).id).toLowerCase();
                return n_0.compareTo(n_1);
            }
            return Integer.compare(((Dialog)d_0.getValue()).id, ((Dialog)d_1.getValue()).id);
        });
        return list;
    }

    static {
        isName = true;
    }
}

